<?php
/**
 * Class that operate on table 'damagedproduct'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-07 15:33
 */
class DamagedproductMySqlExtDAO extends DamagedproductMySqlDAO{
	
	public function queryAllWithStoreName(){
		
		$sql = 'SELECT damagedproduct.*,store.storeName ,product.productName,product.productBuyPrice
		        FROM damagedproduct
				INNER JOIN store on damagedproduct.storeId = store.storeId
				INNER JOIN product on damagedproduct.productId= product.productId';
					
		$sqlQuery = new SqlQuery($sql);
		//print_r($sqlQuery);
		return $this->getList($sqlQuery);
	}
	
	public function queryByProductionOrderIdAndGetProductName($value){
		$sql = 'SELECT damagedproduct.*,product.productName 
					FROM damagedproduct
					INNER JOIN product ON product.productId =damagedproduct.productId 
					AND damagedproduct.productionOrderId = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}
	
	//productionorder
	public function queryByProductionOrderIdAndGetProductNameAndUnitName($productionOrderId){
		$sql = 'SELECT damagedproduct. * , product.productName , unit.unitName
		FROM damagedproduct
		LEFT JOIN product
			 ON product.productId = damagedproduct.productId
		LEFT JOIN productunit 
			 ON  productunit.productunitid=damagedproduct.measurUnitId
		LEFT JOIN unit
         	 ON unit.unitId= productunit.unitid
		where damagedproduct.productionOrderId = ?';
		
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($productionOrderId);
		return $this->getList($sqlQuery);
	}
	
	
	
}
?>